using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Drawing;

namespace Application_Monitor
{
    /// <summary>
    /// This class is used to calculate the Pixels Per Inch
    /// </summary>
    class PixelsPerInch
    {
        #region Member variable(s) declaration
        float m_PPIX = 0;
        float m_PPIY = 0;
        [DllImport("gdi32.dll")]
        private static extern Int32 GetDeviceCaps(IntPtr hdc, Int32 capindex);
        public static short HORZSIZE = 4; // Horizontal size in millimeters 
        public static short VERTSIZE = 6; // Vertical size in millimeters 
        public static short HORZRES = 8; // Horizontal width in pixels 
        public static short VERTRES = 10; // Vertical height in pixels 
        #endregion

        #region Property(s) Declaration
        /// <summary>
        /// Gets or sets the Pixels Per Inch for X resolution
        /// </summary>
        public float PPIX
        {
            get
            {
                return m_PPIX;
            }
            set
            {
                m_PPIX = value;
            }
        }
        /// <summary>
        /// Gets or sets the Pixels Per Inch for Y resolution
        /// </summary>
        public float PPIY
        {
            get
            {
                return m_PPIY;
            }
            set
            {
                m_PPIY = value;
            }
        }
        #endregion

        #region Public Member functions
        public PixelsPerInch(Graphics objGraphics)
        {
                IntPtr hDC = objGraphics.GetHdc(); // Get the device context handle
               // screen X axis resolution
                float resx = Convert.ToSingle(GetDeviceCaps(hDC, HORZRES));
                // screen Y axis resolution
                float resy = Convert.ToSingle(GetDeviceCaps(hDC, VERTRES));
                // screen width in inches 
                float hsz = Convert.ToSingle(GetDeviceCaps(hDC, HORZSIZE)) / 25.4f;
                // screen height in inches 
                float vsz = Convert.ToSingle(GetDeviceCaps(hDC, VERTSIZE)) / 25.4f;
                m_PPIX = resx / hsz;
                m_PPIY = resy / vsz;
                objGraphics.ReleaseHdc(hDC);
            }
        #endregion

        }
}
